package com.bxm.adsprod.service.ticket.event.listeners;

import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.service.ticket.event.BalanceChangedEvent;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.List;

/**
 * 广告主余额变更事件
 *
 * @author allen
 * @since V1.0.0 2017/12/27
 */
@Component
public class BalanceChangedEventListener implements EventListener<BalanceChangedEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceChangedEventListener.class);

    @Autowired
    private TicketService ticketService;
    @Autowired
    private AdsmanagerService adsmanagerService;

    @Override
    @Subscribe
    public void consume(BalanceChangedEvent event) {
        long finalValue = event.getFinalValue();
        if (finalValue > 0) {
            // 需要对设置为余额不足的广告券恢复到可用状态
            List<Ticket> allTickets = ticketService.getAllTickets();
            for (Ticket ticket : allTickets) {
                if (null == ticket.getAdvertiser()) {
                    continue;
                }
                if (! ticket.getAdvertiser().equals(event.getAdvertiser())) {
                    continue;
                }
                boolean isPauseStatus = ticket.getStatus() == Ticket.STATUS_PAUSE && ticket.getPauseReason() == Ticket.PAUSE_REASON_BALANCE_NOT_ENOUGHT;
                if (! isPauseStatus) {
                    continue;
                }
                BigInteger ticketId = ticket.getId();
                if (adsmanagerService.updateAdTicket(ticketId, Ticket.STATUS_OPEN, Ticket.PAUSE_REASON_NONE)) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("广告券({})状态(打开)更新完成", ticketId);
                    }
                }
                else {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("广告券({})状态(打开)更新失败!", ticketId);
                    }
                }
            }
        }
    }
}
