package com.bxm.adsprod.service.ticket.event.listeners;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.service.ticket.event.BalanceNotEnoughEvent;
import com.bxm.adsprod.common.eventbus.EventListener;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * 广告主余额事件
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Component
public class BalanceNotEnoughEventListener implements EventListener<BalanceNotEnoughEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BalanceNotEnoughEventListener.class);

    @Autowired
    private AdsmanagerService adsmanagerService;

    @Override
    @Subscribe
    public void consume(BalanceNotEnoughEvent event) {
        Ticket ticket = event.getTicket();

        BigInteger id = ticket.getId();
        boolean flag = adsmanagerService.updateAdTicket(id, Ticket.STATUS_PAUSE, Ticket.PAUSE_REASON_BALANCE_NOT_ENOUGHT);

        if (flag) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("广告券({})状态(暂停-余额不足)更新完成", id);
            }
        }
        else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("广告券({})状态(暂停-余额不足)更新失败!", id);
            }
        }
    }
}
