package com.bxm.adsprod.service.ticket.event.listeners;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.common.eventbus.EventListener;
import com.bxm.adsprod.integration.adsmanager.AdsmanagerService;
import com.bxm.adsprod.service.ticket.event.DailyBudgetNotEnoughEvent;
import com.google.common.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigInteger;

/**
 * <h3>日预算不足事件</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/19
 */
@Component
public class DailyBudgetEventListener implements EventListener<DailyBudgetNotEnoughEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(DailyBudgetEventListener.class);

    @Autowired
    private AdsmanagerService adsmanagerService;

    @Override
    @Subscribe
    public void consume(DailyBudgetNotEnoughEvent event) {
        Ticket ticket = event.getTicket();

        BigInteger id = ticket.getId();
        boolean flag = adsmanagerService.updateAdTicket(id, Ticket.STATUS_PAUSE, Ticket.PAUSE_REASON_OUT_OF_DAILYBUDGET);

        if (flag) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("广告券({})状态(暂停-日预算不足)更新完成", id);
            }
        }
        else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("广告券({})状态(暂停-日预算不足)更新失败!", id);
            }
        }
    }
}
