package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.eventbus.EventPark;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.service.ticket.event.BalanceNotEnoughEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;

/**
 * <h3>广告主余额过滤</h3>
 *
 * @author allen
 * @since V1.0.0 2018/01/04
 */
@Component
public class AdvertiserBalanceInterceptor extends AbstractInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertiserBalanceInterceptor.class);

    @Autowired
    private AdvertiserService advertiserService;
    @Autowired
    private EventPark eventPark;

    @Override
    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel) invocation.getRequestModel();

        if (requestModel.isEmpty()) {
            return;
        }

        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        for (; iterator.hasNext(); ) {
            Ticket ticket = iterator.next();

            if (! ticket.isCPC()) {
                continue;
            }

            BigInteger advertiser = ticket.getAdvertiser();

            Long balance = advertiserService.getAdvertiserBalance(advertiser);

            if (null == balance || balance <= ticket.getPrice()) {
                iterator.remove();

                eventPark.post(new BalanceNotEnoughEvent(this, ticket));

                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[AdvertiserBalanceInterceptor] removed {}", ticket.getId());
                }
            }
        }
    }
}
