package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.App;
import com.bxm.adsprod.facade.ticket.Os;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.ip.IP;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * @author allen
 * @date 2017-12-04
 */
public class FilterRequestModel implements Serializable {

    private static final long serialVersionUID = 4654851721352400959L;

    /**
     * 广告位
     */
    private Position position;

    /**
     * 用户ID。
     */
    private String uid;
    private String imei;
    private int os = Os.UNKNOWN;
    private int app = App.UNKNOWN;

    private String ip;
    private IP iprst;

    private List<Ticket> tickets;

    /**
     * 仅兼容老平台中的广告位标签地域限制规则
     */
    private String city;

    public boolean isNoImei() {
        String imei = getImei();
        return StringUtils.isBlank(getImei()) || StringUtils.equals("__IMEI__", imei);
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public boolean isEmpty() {
        return null == tickets || tickets.size() == 0;
    }

    public Position getPosition() {
        return position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public List<Ticket> getTickets() {
        return tickets;
    }

    public void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
    }

    public int getOs() {
        return os;
    }

    public void setOs(int os) {
        this.os = os;
    }

    public int getApp() {
        return app;
    }

    public void setApp(int app) {
        this.app = app;
    }

    public IP getIprst() {
        return iprst;
    }

    public void setIprst(IP iprst) {
        this.iprst = iprst;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }
}
