package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.adsprod.service.ticket.utils.InterceptorChainUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * <h3>广告券拦截器链，可以设置链条顺序</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/07
 */
@Component
public final class TicketFilterInterceptorChain implements Interceptor, ApplicationListener<ContextRefreshedEvent> {

    @Autowired
    private TicketRegionInterceptor ticketRegionInterceptor;

    @Autowired
    private TicketUserOsInterceptor ticketUserOsInterceptor;

    @Autowired
    private TicketUserWechatInterceptor ticketUserWechatInterceptor;

    @Autowired
    private TicketPositionInterceptor ticketPositionInterceptor;

    @Autowired
    private TicketTimelineInterceptor ticketTimelineInterceptor;

    @Autowired
    private PositionDomainRegionInterceptor positionDomainRegionInterceptor;

    @Autowired
    private PositionTagRegionInterceptor positionTagRegionInterceptor;

    @Autowired
    private PositionTagRegionForOldInterceptor positionTagRegionForOldInterceptor;

    @Autowired
    private SelfProdInterceptor selfProdInterceptor;

    @Autowired
    private TicketTimesInterceptor ticketTimesInterceptor;

    @Autowired
    private TicketUserGradeInterceptor ticketUserGradeInterceptor;

    @Autowired
    private AdvertiserBalanceInterceptor advertiserBalanceInterceptor;

    private final List<Interceptor> interceptors = Lists.newArrayList();

    private void addInterceptors() {
        interceptors.add(advertiserBalanceInterceptor);
        interceptors.add(ticketUserOsInterceptor);
        interceptors.add(ticketUserWechatInterceptor);
        interceptors.add(ticketRegionInterceptor);
        interceptors.add(ticketPositionInterceptor);
        interceptors.add(ticketTimelineInterceptor);
        interceptors.add(positionDomainRegionInterceptor);
        interceptors.add(positionTagRegionInterceptor);
        interceptors.add(positionTagRegionForOldInterceptor);
        interceptors.add(selfProdInterceptor);
        interceptors.add(ticketTimesInterceptor);
        interceptors.add(ticketUserGradeInterceptor);

        InterceptorChainUtils.setChain(interceptors);
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (null == event.getApplicationContext().getParent()) {
            addInterceptors();
        }
    }

    @Override
    public void intercept(Invocation invocation) {
        interceptors.get(0).intercept(invocation);
    }

}
