package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.commons.CachePushableFields;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.model.so.rules.TicketPositionRuleSo;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 广告券广告位拦截器
 * @author allen
 * @date 2017-12-06
 */
@Component
public class TicketPositionInterceptor extends AbstractInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketPositionInterceptor.class);

    @Autowired(required = false)
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Autowired(required = false)
    @Qualifier("jedisUpdater")
    private Updater updater;

    public TicketPositionInterceptor() {
        super();
    }

    public TicketPositionInterceptor(Interceptor next) {
        super(next);
    }

    @Override
    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel) invocation.getRequestModel();

        if (requestModel.isEmpty()) {
            return;
        }

        Position position = requestModel.getPosition();
        String id = position.getId();
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        for (; iterator.hasNext(); ) {
            Ticket ticket = iterator.next();
            BigInteger ticketId = ticket.getId();

            Map<String, Object> parameters = Maps.newHashMap();
            parameters.put(CachePushableFields.TICKET_ID, ticketId);

            TicketPositionRuleSo rule = fetcher.fetch(keyGenerator(parameters), null, TicketPositionRuleSo.class);
            if (null == rule) {
                continue;
            }
            boolean removing = (rule.isBlackList() && rule.getPositions().contains(id))
                    || (!rule.isBlackList() && !rule.getPositions().contains(id));
            if (removing) {
                iterator.remove();

                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketPositionInterceptor] remove {}.", ticketId);
                }
            }
        }
    }

    public static KeyGenerator keyGenerator(Map<String, Object> parameters) {
        return new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "FILTER", "POSITION", parameters.get(CachePushableFields.TICKET_ID));
            }
        };
    }

}
