package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>用户平台拦截器</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/13
 */
@Component
public class TicketUserOsInterceptor extends AbstractInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserOsInterceptor.class);

    public TicketUserOsInterceptor() {
        super();
    }

    public TicketUserOsInterceptor(Interceptor next) {
        super(next);
    }

    @Override
    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel) invocation.getRequestModel();

        if (requestModel.isEmpty()) {
            return;
        }
        int os = requestModel.getOs();
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            if (! ticket.isSupportedOs(os)) {
                iterator.remove();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketUserOsInterceptor] remove {}.", ticket.getId());
                }
            }
        }
    }
}
