package com.bxm.adsprod.service.ticket.filter;

import com.bxm.adsprod.facade.ticket.App;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.common.interceptor.AbstractInterceptor;
import com.bxm.adsprod.common.interceptor.Interceptor;
import com.bxm.adsprod.common.interceptor.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.Iterator;
import java.util.List;

/**
 * <h3>用户微信请求拦截器</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/13
 */
@Component
public class TicketUserWechatInterceptor extends AbstractInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(TicketUserWechatInterceptor.class);

    public TicketUserWechatInterceptor() {
        super();
    }

    public TicketUserWechatInterceptor(Interceptor next) {
        super(next);
    }

    @Override
    protected void doIntercept(Invocation invocation) {
        FilterRequestModel requestModel = (FilterRequestModel) invocation.getRequestModel();

        if (requestModel.isEmpty()) {
            return;
        }
        int app = requestModel.getApp();
        boolean wechat = app == App.WECHAT;
        List<Ticket> tickets = requestModel.getTickets();
        Iterator<Ticket> iterator = tickets.iterator();
        while (iterator.hasNext()) {
            Ticket ticket = iterator.next();
            if ((wechat && ! ticket.isSupportedWechat())) {
                iterator.remove();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[TicketUserOsInterceptor] remove {}.", ticket.getId());
                }
            }
        }
    }
}
