package com.bxm.adsprod.service.ticket.filter.times;

import com.bxm.adsprod.service.user.UserStatisticsService;

import java.math.BigInteger;

/**
 * 每天曝光次数规则处理器
 * @author allen
 * @date 2017-12-06
 */
public class EveryDayViewTimesRuleProcessor extends AbstractTimeRuleProcessor {

    public EveryDayViewTimesRuleProcessor(UserStatisticsService userStatisticsService, long max) {
        super(userStatisticsService, max);
    }

    @Override
    public boolean isOutOfTimes(String uid, BigInteger ticketId) {
        return userStatisticsService.countViewOfToday(uid, ticketId) >= max;
    }
}
