package com.bxm.adsprod.service.ticket.filter.times;

import com.bxm.adsprod.service.user.UserStatisticsService;

import java.math.BigInteger;

/**
 * 每周点击次数规则处理器
 * @author allen
 * @date 2017-12-06
 */
public class EveryWeekClickTimesRuleProcessor extends AbstractTimeRuleProcessor {

    public EveryWeekClickTimesRuleProcessor(UserStatisticsService userStatisticsService, long max) {
        super(userStatisticsService, max);
    }

    @Override
    public boolean isOutOfTimes(String uid, BigInteger ticketId) {
        return userStatisticsService.countClickOfThisWeek(uid, ticketId) >= max;
    }
}
