package com.bxm.adsprod.service.ticket.filter.times;

import com.bxm.adsprod.service.user.UserStatisticsService;

import java.math.BigInteger;

/**
 * 每周曝光次数规则处理器
 * @author allen
 * @date 2017-12-06
 */
public class EveryWeekViewTimesRuleProcessor extends AbstractTimeRuleProcessor {

    public EveryWeekViewTimesRuleProcessor(UserStatisticsService userStatisticsService, long max) {
        super(userStatisticsService, max);
    }

    @Override
    public boolean isOutOfTimes(String uid, BigInteger ticketId) {
        return userStatisticsService.countViewOfThisWeek(uid, ticketId) >= max;
    }
}
