package com.bxm.adsprod.service.ticket.filter.times;

import com.bxm.adsprod.model.so.rules.TicketTimesRuleSo;
import com.bxm.adsprod.service.user.UserStatisticsService;

/**
 * 频次规则处理器工厂，可返回不同类型的处理器。
 *
 * @author allen
 * @date 2017-12-06
 */
public final class TimesRuleProcessorFactory {

    private TimesRuleProcessorFactory() {}

    public static TimesRuleProcessor create(UserStatisticsService userStatisticsService, TicketTimesRuleSo.Entry entry) {
        int cycle = entry.getCycle();
        int type = entry.getType();
        long max = entry.getCount();
        if (TicketTimesRuleSo.Entry.CYCLE_EVERYDAY == cycle && TicketTimesRuleSo.Entry.TYPE_VIEW == type) {
            return new EveryDayViewTimesRuleProcessor(userStatisticsService, max);
        }
        else if (TicketTimesRuleSo.Entry.CYCLE_EVERYDAY == cycle && TicketTimesRuleSo.Entry.TYPE_CLICK == type) {
            return new EveryDayClickTimesRuleProcessor(userStatisticsService, max);
        }
        else if (TicketTimesRuleSo.Entry.CYCLE_EVERYWEEK == cycle && TicketTimesRuleSo.Entry.TYPE_VIEW == type) {
            return new EveryWeekViewTimesRuleProcessor(userStatisticsService, max);
        }
        else if (TicketTimesRuleSo.Entry.CYCLE_EVERYWEEK == cycle && TicketTimesRuleSo.Entry.TYPE_CLICK == type) {
            return new EveryWeekClickTimesRuleProcessor(userStatisticsService, max);
        }
        else {
            throw new UnsupportedOperationException();
        }
    }
}
