package com.bxm.adsprod.service.ticket.pushable;

import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketProfitForCpa;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Converter;
import com.bxm.warcar.cache.push.HashUpdating;
import com.bxm.warcar.cache.push.JSONArrayPushable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 *
 * @author allen
 * @since V1.0.0 2017/12/13
 */
@Component
@CachePush("TICKET_PROFIT_FOR_CPA")
public class TicketProfitForCpaPushable extends JSONArrayPushable<TicketProfitForCpa> implements HashUpdating<TicketProfitForCpa> {

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;

    public TicketProfitForCpaPushable() {
        super(new Converter<TicketProfitForCpa>() {
            @Override
            public Object convert(TicketProfitForCpa object) {
                return object.getProfit();
            }
        });
    }

    @Override
    public String getField(Map<String, Object> parameters, TicketProfitForCpa object) {
        return String.valueOf(object.getTicketId());
    }

    @Override
    protected Class<TicketProfitForCpa> getClsType() {
        return TicketProfitForCpa.class;
    }

    @Override
    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters, TicketProfitForCpa object) {
        String date = object.getDate();
        LocalDate localDate = LocalDate.parse(date, DateTimeFormatter.ofPattern(object.getDatePattern()));
        return TicketKeyGenerator.getTicketProfitForCpa(localDate);
    }

    @Override
    protected Updater getUpdater() {
        return updater;
    }
}
