package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.user.NotEnoughTimesException;

import java.math.BigInteger;

/**
 * 用户抽奖次数服务
 * @author allen
 * @since 1.0.0
 */
public interface UserAwardTimesService {

    /**
     * 递减抽奖次数，并且返回递减后的次数
     * @param uid
     * @param positionId
     * @param activityId
     * @return
     * @throws NotEnoughTimesException 抽奖次数不足抛出的此异常
     */
    long decrementAndGet(String uid, String positionId, BigInteger activityId) throws NotEnoughTimesException;
}
