package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.user.NotEnoughTimesException;
import com.bxm.adsprod.service.activity.ActivityService;
import com.bxm.adsprod.model.so.activity.ActivitySo;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.DefaultValTrackable;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.ValueOutOfLimitException;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.math.BigInteger;

/**
 * @author allen
 * @since 1.0.0
 */
@org.springframework.stereotype.Service
public class UserAwardTimesServiceImpl implements UserAwardTimesService {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserAwardTimesServiceImpl.class);

    @Autowired(required = false)
    @Qualifier("jedisCounter")
    private Counter counter;

    @Autowired(required = false)
    private ActivityService activityService;

    @Override
    public long decrementAndGet(String uid, String positionId, BigInteger activityId) throws NotEnoughTimesException {

        KeyGenerator keyGenerator = new KeyGenerator() {
            @Override
            public String generateKey() {
                return KeyBuilder.build("AD", "COUNTER", "ACTIVITY", activityId, positionId, uid);
            }
        };

        try {
            Long count = counter.decrementAndGet(keyGenerator, new DefaultValTrackable() {
                @Override
                public long getDefaultVal() {
                    ActivitySo activity = activityService.getActivity(activityId);
                    if (null == activity) {
                        if (LOGGER.isWarnEnabled()) {
                            LOGGER.warn("Invalid activity: {}", activityId);
                        }
                        return 0;
                    }
                    return activity.getAwardTimes();
                }
            }, 0, TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday()));

            return count;
        } catch (IllegalStateException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("decrementAndGet:", e);
            }
        } catch (ValueOutOfLimitException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("decrementAndGet:", e);
            }
        }

        return 0;
    }
}
