package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.ticket.Ticket;

/**
 * 用户相关服务
 * @author allen
 * @since 1.0.0
 */
public interface UserService {

    /**
     * 返回这个用户今天最后获得的广告券
     *
     * @param uid
     * @return
     */
    Ticket getLastAcquiredTicket(String uid);


    /**
     * 设置这个用户最后获得的广告券，有效期为今天
     *
     * @param ticket
     * @param uid
     */
    void setLastAcquireTicket(Ticket ticket, String uid);
}
