package com.bxm.adsprod.service.user;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;


/**
 * @author allen
 * @since 1.0.0
 */
@org.springframework.stereotype.Service
public class UserServiceImpl implements UserService {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserServiceImpl.class);

    @Autowired
    @Qualifier("jedisUpdater")
    private Updater updater;
    @Autowired
    @Qualifier("jedisFetcher")
    private Fetcher fetcher;

    @Override
    public Ticket getLastAcquiredTicket(String uid) {
        return fetcher.fetch(TicketKeyGenerator.User.getUser(uid), null, Ticket.class);
    }

    @Override
    public void setLastAcquireTicket(Ticket ticket, String uid) {
        if (null == ticket) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("inspectors is null.");
            }
            return;
        }
        if (StringUtils.isBlank(uid)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("uid is null.");
            }
            return;
        }
        updater.update(TicketKeyGenerator.User.getUser(uid), ticket, TypeHelper.castToInt(DateHelper.getRemainSecondsOfToday()));
    }
}
