package com.bxm.adsprod.service.user;

import java.math.BigInteger;

/**
 * <h3>用户统计服务</h3>
 * <p></p>
 *
 * @author allen
 * @since V1.0.0 2017/12/06
 */
public interface UserStatisticsService {


    /**
     * 返回这个用户指定广告券今天曝光次数
     *
     * @param uid
     * @param ticketId
     * @return
     */
    long countViewOfToday(String uid, BigInteger ticketId);

    /**
     * 返回这个用户指定广告今天点击次数
     *
     * @param uid
     * @param ticketId
     * @return
     */
    long countClickOfToday(String uid, BigInteger ticketId);

    /**
     * 返回这个用户指定广告本周曝光次数
     *
     * @param uid
     * @param ticketId
     * @return
     */
    long countViewOfThisWeek(String uid, BigInteger ticketId);

    /**
     * 返回这个用户指定广告本周点击次数
     *
     * @param uid
     * @param ticketId
     * @return
     */
    long countClickOfThisWeek(String uid, BigInteger ticketId);
}
