package com.bxm.adsprod.service.user.pushable;

import com.bxm.adsprod.facade.user.UserGrade;
import com.bxm.adsprod.common.pushable.annotation.CachePush;
import com.bxm.adsprod.service.ticket.filter.TicketUserGradeInterceptor;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.autoconfigure.jedis.JedisConfiguration;
import com.bxm.warcar.cache.impls.redis.JedisUpdater;
import com.bxm.warcar.cache.push.JSONObjectPushable;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPool;

import java.util.Map;

/**
 * <h3></h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/15
 */
@Component
@CachePush("TICKET_USER_GRADE")
public class TicketUserGradePushable extends JSONObjectPushable<UserGrade> {

    @Autowired(required = false)
    @Qualifier("jedis1Updater")
    private Updater updater;

    @Override
    protected Class<UserGrade> getClsType() {
        return UserGrade.class;
    }

    @Override
    public Updater getUpdater() {
        return updater;
    }

    @Override
    protected int getExpireTimeInSeconds() {
        // 30 minutes
        return 30 * 60;
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        UserGrade object = ArrayUtils.isNotEmpty(data) ? serialize(data) : null;
        if (null != object && object.isValid()) {
            // 没有结果的数据不存储，可减少缓存的使用量

            KeyGenerator keyGenerator = getKeyGenerator(parameters);

            doUpdate(object, keyGenerator, parameters, data);
        }
    }

    @Override
    protected KeyGenerator getKeyGenerator(Map<String, Object> parameters) {
        return TicketUserGradeInterceptor.keyGenerator(parameters);
    }

}
