/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.controller;

import com.bxm.adsprod.third.constant.ErrorCode;
import com.bxm.adsprod.third.exception.ThirdException;
import com.bxm.adsprod.third.model.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler
    public <T> Result<T> failResult(Exception e) {
        if (e instanceof ThirdException) {
            ThirdException te = (ThirdException)e;
            return BaseController.fail(te.getCode(), te.getDesc());
        }
        this.logger.warn("\u53d1\u751f\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
        return BaseController.fail(ErrorCode.E9999999);
    }

    public <T> Result<T> failResult(ErrorCode errorCode) {
        this.logger.warn("\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u7801={}, \u9519\u8bef\u63cf\u8ff0={}", (Object)errorCode.getCode(), (Object)errorCode.getDesc());
        return BaseController.fail(errorCode);
    }

    public <T> Result<T> successResult(T t) {
        return BaseController.success(t);
    }

    public <T> Result<T> successResult() {
        return BaseController.success(null);
    }

    private static <T> Result<T> success(T t) {
        Result<T> result = new Result<T>();
        result.setCode(ErrorCode.E0000000.getCode());
        if (null != t) {
            result.setData(t);
        }
        result.setDesc(ErrorCode.E0000000.getDesc());
        return result;
    }

    private static <T> Result<T> fail(ErrorCode code) {
        Result result = new Result();
        result.setCode(code.getCode());
        result.setDesc(code.getDesc());
        return result;
    }

    private static <T> Result<T> fail(String code, String desc) {
        Result result = new Result();
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }
}

