/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.third.controller.landpage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.adsprod.third.config.UploadHelper;
import com.bxm.adsprod.third.controller.landpage.AuthController;
import com.bxm.adsprod.third.model.landpage.PageConfig;
import com.bxm.adsprod.third.model.landpage.PageItem;
import com.bxm.adsprod.third.service.landpage.AuthService;
import com.bxm.adsprod.third.service.landpage.PageConfigService;
import com.bxm.warcar.utils.response.ResponseModel;
import com.bxm.warcar.utils.response.ResponseModelFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/page"})
public class PageController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthController.class);
    @Autowired
    private AuthService authService;
    @Autowired
    private PageConfigService pageConfigService;
    @Autowired
    private UploadHelper helper;

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public ResponseModel<PageConfig> get(String pageId) {
        try {
            return ResponseModelFactory.SUCCESS((Object)this.pageConfigService.get(pageId));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseModelFactory.FAILED();
        }
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public ResponseModel<PageConfig> save(String token, String pageConfig) {
        try {
            if (StringUtils.isBlank((CharSequence)pageConfig)) {
                return ResponseModelFactory.FAILED();
            }
            PageConfig config = (PageConfig)JSONObject.parseObject((String)pageConfig, PageConfig.class);
            if (!this.authService.hasPermission(token, config.getPageId())) {
                return ResponseModelFactory.FAILED401();
            }
            this.pageConfigService.saveOrUpdate(config);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseModelFactory.FAILED();
        }
        return ResponseModelFactory.SUCCESS(null);
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseModel<String> upload(String token, String pageId, HttpServletRequest request) {
        String url = null;
        try {
            if (!this.authService.hasPermission(token, pageId)) {
                return ResponseModelFactory.FAILED401();
            }
            JSONArray urlString = (JSONArray)this.helper.uploadImg(request, token);
            if (urlString != null) {
                JSONObject urlJson = urlString.getJSONObject(0);
                url = (String)urlJson.get((Object)"url");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ResponseModelFactory.FAILED();
        }
        return ResponseModelFactory.SUCCESS(url);
    }

    public static void main(String[] args) {
        PageConfig config = new PageConfig();
        config.setPageId("1");
        ArrayList list = Lists.newArrayList();
        PageItem pageItem = new PageItem();
        pageItem.setImage("11");
        pageItem.setNumber("1");
        PageItem pageItem1 = new PageItem();
        pageItem1.setImage("22");
        pageItem1.setNumber("2");
        list.add(pageItem);
        list.add(pageItem1);
        config.setItems(list);
        System.out.println(JSONObject.toJSONString((Object)config));
    }
}

