/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.interceptor;

import com.bxm.warcar.integration.interceptor.Interceptor;
import com.bxm.warcar.integration.interceptor.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptor
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterceptor.class);
    private Interceptor nextInterceptor;

    public AbstractInterceptor() {
        this(END);
    }

    public AbstractInterceptor(Interceptor next) {
        this.nextInterceptor = next;
    }

    protected abstract void doIntercept(Invocation var1);

    @Override
    public void intercept(Invocation invocation) {
        block4: {
            try {
                this.doIntercept(invocation);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("intercept: ", (Throwable)e);
            }
        }
        invocation.setPreInterceptor(this);
        if (null == this.nextInterceptor) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("next interceptor is null, ignore.");
            }
            return;
        }
        this.nextInterceptor.intercept(invocation);
    }

    public void setNextInterceptor(Interceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }
}

