/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.timer.jobs;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.dal.activity.ActivityMapper;
import com.bxm.adsprod.facade.activity.ActivityKeyGenerator;
import com.bxm.adsprod.facade.activity.ActivityService;
import com.bxm.adsprod.facade.activity.WeightEntry;
import com.bxm.adsprod.model.dto.ActivityPositionRelationDto;
import com.bxm.adsprod.model.dto.ActivityPositonWeightDto;
import com.bxm.adsprod.timer.Job;
import com.bxm.adsprod.timer.jobs.PositionDataPullJob;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPool;

@Component
public class ActivityDataPullJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionDataPullJob.class);
    private static final int DEFAULT_WEIGHT = 200;
    private static final String SPLIT_CHAR = ",";
    @Value(value="${activity.db}")
    private int activityDb;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;
    @Autowired
    private ActivityMapper activityMapper;
    @Reference(version="1.0.0")
    private ActivityService activityService;

    @Override
    public void execute() {
        Long start = System.currentTimeMillis();
        try {
            KeyGenerator tmpPostion6H = ActivityKeyGenerator.Filter.getTmpPostion6H();
            String positionStr = (String)this.fetcher.fetchWithSelector(tmpPostion6H, String.class, this.activityDb);
            positionStr = positionStr + ",DEFAULT";
            String[] positionIds = StringUtils.split((String)positionStr, (String)SPLIT_CHAR);
            Map<String, List<ActivityPositonWeightDto>> positionAct = this.getPositonActMap();
            List<ActivityPositonWeightDto> defaultAct = this.activityMapper.selectDefaultAct(new Date());
            KeyGenerator defaultNumKey = ActivityKeyGenerator.Filter.getActDefaultNum();
            String dafaultView = (String)this.fetcher.fetchWithSelector(defaultNumKey, String.class, this.activityDb);
            dafaultView = StringUtils.isNotBlank((CharSequence)dafaultView) ? dafaultView : "100";
            KeyGenerator defaultRepeatKey = ActivityKeyGenerator.Filter.getActDefaultRepeat();
            String defaultRepeatClicks = (String)this.fetcher.fetchWithSelector(defaultRepeatKey, String.class, this.activityDb);
            defaultRepeatClicks = StringUtils.isNotBlank((CharSequence)defaultRepeatClicks) ? defaultRepeatClicks : "200";
            for (String positionId : positionIds) {
                List<ActivityPositonWeightDto> actWeightList = positionAct.get(positionId);
                actWeightList = CollectionUtils.isEmpty(actWeightList) ? defaultAct : actWeightList;
                Map<Integer, Integer> activityIdFactor = this.extractActivityAndFactorInfo(actWeightList);
                List entries = this.activityService.getPerClick(positionId, dafaultView, defaultRepeatClicks, activityIdFactor);
                HashMap weights = Maps.newHashMap();
                int totalSize = 1;
                for (WeightEntry weightEntry : entries) {
                    weights.put(weightEntry.getActivityId(), weightEntry.getWeight() * totalSize * weightEntry.getInterventionFactor());
                    ++totalSize;
                }
                KeyGenerator actRandomKey = ActivityKeyGenerator.Filter.getActRandomMsg((String)positionId);
                this.updater.updateWithSelector(actRandomKey, (Object)weights, this.activityDb);
            }
            Long end = System.currentTimeMillis();
            LOGGER.info("Pull activity finished in" + (start - end));
        }
        catch (Exception e) {
            LOGGER.error("EXCUTE BIZACTWEIGHT ERROR", (Throwable)e);
        }
    }

    private Map<Integer, Integer> extractActivityAndFactorInfo(List<ActivityPositonWeightDto> actWeightList) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        if (CollectionUtils.isNotEmpty(actWeightList)) {
            for (ActivityPositonWeightDto weight : actWeightList) {
                map.put(weight.getActivityId(), weight.getInterventionFactor());
            }
        }
        return map;
    }

    public Map<String, List<ActivityPositonWeightDto>> getPositonActMap() {
        List actRelations = this.activityMapper.selectPostionAct(new Date());
        HashMap<String, List<ActivityPositonWeightDto>> result = new HashMap<String, List<ActivityPositonWeightDto>>();
        for (ActivityPositionRelationDto relation : actRelations) {
            String positionId = relation.getPositionId();
            ActivityPositonWeightDto value = new ActivityPositonWeightDto();
            value.setActivityId(relation.getActivityId());
            value.setInterventionFactor(relation.getInterventionFactor());
            List record = (List)result.get(positionId);
            record = record == null ? new ArrayList() : record;
            record.add(value);
            result.put(positionId, record);
        }
        return result;
    }
}

