/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.timer.jobs;

import com.bxm.adsprod.convert.media.PositionConvert;
import com.bxm.adsprod.dal.media.PositionMapper;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.model.dao.media.PositionDao;
import com.bxm.adsprod.timer.Job;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PositionDataPullJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionDataPullJob.class);
    @Autowired
    private PositionMapper positionMapper;
    @Autowired
    @Qualifier(value="jedisUpdater")
    private Updater updater;

    @Override
    @Scheduled(initialDelay=1000L, fixedDelay=300000L)
    public void execute() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting pull positions...");
        }
        long start = System.currentTimeMillis();
        List positions = this.positionMapper.selectAll();
        for (PositionDao position : positions) {
            KeyGenerator keyGenerator = TicketKeyGenerator.Media.getPositions();
            this.updater.hupdate(keyGenerator, position.getPositionId(), (Object)PositionConvert.of((PositionDao)position));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Pull finished in {} ms!", (Object)(System.currentTimeMillis() - start));
        }
    }
}

