/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.timer.jobs;

import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.dal.ticket.AdTicketMapper;
import com.bxm.adsprod.facade.advertiser.AdvertiserService;
import com.bxm.adsprod.facade.ticket.IllegalTicketException;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.facade.ticket.TicketStatisticsService;
import com.bxm.adsprod.model.dao.ticket.Ticket;
import com.bxm.adsprod.model.so.rules.TicketTimelineRuleSo;
import com.bxm.adsprod.timer.Job;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.utils.WarnHelper;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TicketStatusRefreshJob
implements Job {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketStatusRefreshJob.class);
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Reference(version="1.0.0")
    private TicketService ticketService;
    @Reference(version="1.0.0")
    private AdvertiserService advertiserService;
    @Reference(version="1.0.0")
    private TicketStatisticsService ticketStatisticsService;
    @Autowired
    private AdTicketMapper adTicketMapper;

    @Override
    @Scheduled(cron="0 0 * * * ?")
    public void execute() {
        List tickets;
        long start = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting refresh status...");
        }
        if (CollectionUtils.isNotEmpty((Collection)(tickets = this.adTicketMapper.findAll(new Ticket())))) {
            ArrayList refreshIfNeeded = Lists.newArrayList();
            for (Ticket ticket : tickets) {
                TicketTimelineRuleSo timelineConf;
                boolean isOpenOrPause;
                BigInteger ticketId = ticket.getId();
                Byte status = ticket.getStatus();
                Integer pauseReason = this.defaultIfEmpty(ticket.getPauseReason(), 0);
                Date startDate = ticket.getValidStartDate();
                Date endDate = ticket.getValidEndDate();
                if (status == 99) continue;
                boolean bl = isOpenOrPause = status == 1 || status == 2;
                if (isOpenOrPause && pauseReason != 4 && TicketStatusRefreshJob.isAfter(endDate)) {
                    ticket.setStatus(Byte.valueOf((byte)2));
                    ticket.setPauseReason(Integer.valueOf(4));
                    refreshIfNeeded.add(ticket);
                    continue;
                }
                if (status == 2 && pauseReason == 3 && TicketStatusRefreshJob.isEqual(startDate)) {
                    this.setOpenIfEnought(refreshIfNeeded, ticket);
                }
                if (status == 2 && pauseReason == 1 && TicketStatusRefreshJob.isMidnight()) {
                    this.setOpenIfEnought(refreshIfNeeded, ticket);
                }
                if (null == (timelineConf = this.getTimelineConf(ticketId))) continue;
                boolean closeIfNeeded = this.isCloseIfNeeded(ticketId, timelineConf.getEntries());
                if (status == 1 && closeIfNeeded) {
                    ticket.setStatus(Byte.valueOf((byte)2));
                    ticket.setPauseReason(Integer.valueOf(5));
                    refreshIfNeeded.add(ticket);
                    continue;
                }
                if (status != 2 || pauseReason != 5 || closeIfNeeded) continue;
                ticket.setStatus(Byte.valueOf((byte)1));
                ticket.setPauseReason(Integer.valueOf(0));
                refreshIfNeeded.add(ticket);
            }
            for (Ticket ticket : refreshIfNeeded) {
                try {
                    if (!this.ticketService.updateTicketStatus(ticket.getId(), ticket.getStatus().byteValue(), ticket.getPauseReason().intValue())) {
                        if (!LOGGER.isWarnEnabled()) continue;
                        LOGGER.warn("[{}] Updating status to {}-{} return fail", new Object[]{ticket.getId(), ticket.getStatus(), ticket.getPauseReason()});
                        continue;
                    }
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("[{}] Updating status to {}-{} success", new Object[]{ticket.getId(), ticket.getStatus(), ticket.getPauseReason()});
                }
                catch (IllegalTicketException e) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error("", (Throwable)e);
                    }
                    WarnHelper.sendDDWarn((String)"75624edea098dd6abe970b50cf4a37f02caecb83cfcc13fd878b7f654b52b2ea", (String)(ticket.getId() + "\u66f4\u65b0\u72b6\u6001\u65f6\u8c03\u7528\u670d\u52a1\u5931\u8d25\u3002" + e.getMessage()), (Boolean)false, (List)Lists.newArrayList());
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Finished in {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private int defaultIfEmpty(Integer v, int defaultValue) {
        return null == v ? defaultValue : v;
    }

    private void setOpenIfEnought(List<Ticket> refreshIfNeeded, Ticket ticket) {
        boolean isCPA;
        boolean bl = isCPA = !ticket.isCPC();
        if (this.isEnought(ticket.getAdvertiser()) || isCPA) {
            Integer budgetDaily = ticket.getBudgetDaily();
            if (null != budgetDaily && budgetDaily > 0) {
                ticket.setStatus(Byte.valueOf((byte)1));
                ticket.setPauseReason(Integer.valueOf(0));
                refreshIfNeeded.add(ticket);
            } else {
                ticket.setStatus(Byte.valueOf((byte)2));
                ticket.setPauseReason(Integer.valueOf(1));
                refreshIfNeeded.add(ticket);
            }
        } else {
            ticket.setStatus(Byte.valueOf((byte)2));
            ticket.setPauseReason(Integer.valueOf(2));
            refreshIfNeeded.add(ticket);
        }
    }

    private boolean isEnought(BigInteger advertiser) {
        Long balance = this.advertiserService.getAdvertiserBalance(advertiser);
        return null != balance && balance > 0L;
    }

    private boolean isCloseIfNeeded(BigInteger ticketId, List<TicketTimelineRuleSo.Entry> entries) {
        int currentHour = Calendar.getInstance().get(11);
        for (TicketTimelineRuleSo.Entry entry : entries) {
            int startHour = entry.getStartHour();
            int endHour = entry.getEndHour();
            boolean isNow = currentHour >= startHour && currentHour < endHour;
            if (!isNow) continue;
            long currentBudget = this.ticketStatisticsService.getBudgetOfTimeline(ticketId, startHour, endHour);
            return currentBudget >= entry.getLimit();
        }
        return true;
    }

    private TicketTimelineRuleSo getTimelineConf(BigInteger ticketId) {
        return (TicketTimelineRuleSo)this.fetcher.fetch(TicketKeyGenerator.Filter.getTimeline((BigInteger)ticketId), null, TicketTimelineRuleSo.class);
    }

    private static boolean isMidnight() {
        return LocalDateTime.now().getHour() == 0;
    }

    private static boolean isAfter(Date date) {
        return LocalDate.now().isAfter(TicketStatusRefreshJob.toLocalDate(date));
    }

    private static boolean isEqual(Date date) {
        return LocalDate.now().isEqual(TicketStatusRefreshJob.toLocalDate(date));
    }

    private static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}

