/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.config.spring.context.annotation.EnableDubbo;
import com.bxm.warcar.configure.spring.SpringBootEnvironmentListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@SpringBootApplication
@EnableDubbo
@EnableScheduling
public class AdsProdWeightApplication
implements SchedulingConfigurer {
    @Value(value="${scheduling.thread.pool.size}")
    private int schedulingThreadPoolSize;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(new Object[]{AdsProdWeightApplication.class});
        application.addListeners(new ApplicationListener[]{new SpringBootEnvironmentListener()});
        application.run(args);
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.taskScheduler());
    }

    @Bean
    public Executor taskScheduler() {
        return new ScheduledThreadPoolExecutor(this.schedulingThreadPoolSize, (ThreadFactory)new NamedThreadFactory("weight"));
    }
}

