/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.weight.scheduler.ArupCalculator;
import com.bxm.adsprod.weight.scheduler.TicketWeight;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CpaArupCalculatorImpl
implements ArupCalculator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpaArupCalculatorImpl.class);
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;

    @Override
    public Map<String, BigDecimal> getArups(List<TicketWeight> tickets, final String positionId) {
        Map map = this.jedisFetcherForOld.hfetchall(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "POSITION", positionId});
            }
        }, null, BigDecimal.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (TicketWeight ticketWeight : tickets) {
            Ticket ticket = ticketWeight.getTicket();
            BigInteger id = ticket.getId();
            String ticketId = String.valueOf(id);
            BigDecimal remote = (BigDecimal)map.get(ticketId);
            BigDecimal arpu = null != remote ? remote : ticketWeight.getGlobalArpu();
            result.put(ticketId, arpu);
        }
        return result;
    }

    @Override
    public void flushTempCache() {
    }
}

