/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler;

import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.weight.scheduler.ArupCalculator;
import com.bxm.adsprod.weight.scheduler.TicketWeight;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CpcArupCalculatorImpl
implements ArupCalculator {
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;
    @Autowired
    @Qualifier(value="jedis2Fetcher")
    private Fetcher fetcher;

    @Override
    public Map<String, BigDecimal> getArups(List<TicketWeight> tickets, final String positionId) {
        Map map = this.jedisFetcherForOld.hfetchall(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "POSITION", positionId});
            }
        }, null, BigDecimal.class);
        Map ocpcMap = this.fetcher.hfetchall(new KeyGenerator(){

            public String generateKey() {
                return KeyBuilder.build((Object[])new Object[]{"AD", "COUNT", "24", "POSITION", positionId});
            }
        }, BigDecimal.class);
        if (MapUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        }
        if (MapUtils.isEmpty((Map)ocpcMap)) {
            ocpcMap = Maps.newHashMap();
        }
        HashMap result = Maps.newHashMap();
        for (TicketWeight ticketWeight : tickets) {
            Ticket ticket = ticketWeight.getTicket();
            BigInteger id = ticket.getId();
            String ticketId = String.valueOf(id);
            BigDecimal arpu = null;
            if (ticketWeight.isOcpc()) {
                arpu = (BigDecimal)ocpcMap.get(ticketId);
            }
            if (null == arpu) {
                arpu = (BigDecimal)map.get(ticketId);
            }
            if (null == arpu) {
                arpu = ticketWeight.getGlobalArpu();
            }
            result.put(ticketId, arpu);
        }
        return result;
    }

    @Override
    public void flushTempCache() {
    }
}

