/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler;

import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.weight.scheduler.MifCalculator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MifCalculatorImpl
implements MifCalculator {
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;

    private static KeyGenerator keyGenerator(BigInteger ticketId, String positionId) {
        HashMap parameters = Maps.newHashMap();
        parameters.put("ticketid", ticketId);
        parameters.put("positionid", positionId);
        return TicketKeyGenerator.getTicketMif((Map)parameters);
    }

    @Override
    public BigDecimal getMif(BigInteger ticketId, String positionId) {
        KeyGenerator withoutPosition = MifCalculatorImpl.keyGenerator(ticketId, null);
        KeyGenerator withPosition = MifCalculatorImpl.keyGenerator(ticketId, positionId);
        Double rst = (Double)this.fetcher.fetch(withPosition, null, Double.class);
        if (null == rst) {
            rst = (Double)this.fetcher.fetch(withoutPosition, null, Double.class);
        }
        return this.returnValue(rst);
    }

    @Override
    public BigDecimal getMif(BigInteger ticketId) {
        KeyGenerator withoutPosition = MifCalculatorImpl.keyGenerator(ticketId, null);
        Double rst = (Double)this.fetcher.fetch(withoutPosition, null, Double.class);
        return this.returnValue(rst);
    }

    private BigDecimal returnValue(Double rst) {
        return null == rst ? new BigDecimal(1) : new BigDecimal(rst).setScale(7, RoundingMode.HALF_UP);
    }
}

