/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adsprod.weight.scheduler;

import com.alibaba.dubbo.common.utils.NamedThreadFactory;
import com.alibaba.dubbo.config.annotation.Reference;
import com.bxm.adsprod.facade.media.Position;
import com.bxm.adsprod.facade.ticket.Ticket;
import com.bxm.adsprod.facade.ticket.TicketKeyGenerator;
import com.bxm.adsprod.facade.ticket.TicketService;
import com.bxm.adsprod.weight.Scheduler;
import com.bxm.adsprod.weight.commons.WeightConfiguration;
import com.bxm.adsprod.weight.scheduler.ArupCalculator;
import com.bxm.adsprod.weight.scheduler.MifCalculator;
import com.bxm.adsprod.weight.scheduler.PriceFloatCalculator;
import com.bxm.adsprod.weight.scheduler.TicketWeight;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.utils.TypeHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={WeightConfiguration.class})
public class WeightCalculateScheduler
implements Scheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightCalculateScheduler.class);
    private final ExecutorService primaryPool;
    private static final int FIXED_DELAY_SECONDS = 600;
    private static final int FIXED_DELAY_MILLISECONDS = 600000;
    @Autowired
    @Qualifier(value="cpcArupCalculatorImpl")
    private ArupCalculator cpcArupCalculator;
    @Autowired
    @Qualifier(value="cpaArupCalculatorImpl")
    private ArupCalculator cpaArupCalculator;
    @Autowired
    private PriceFloatCalculator priceFloatCalculator;
    @Autowired
    private MifCalculator mifCalculator;
    @Autowired
    @Qualifier(value="jedisFetcher")
    private Fetcher fetcher;
    @Autowired
    @Qualifier(value="jedisFetcherForOld")
    private Fetcher jedisFetcherForOld;
    @Autowired
    private JedisPool jedisPool;
    @Reference(version="1.0.0")
    private TicketService ticketService;

    public WeightCalculateScheduler(WeightConfiguration configuration) {
        this.primaryPool = new ThreadPoolExecutor(configuration.getPrimaryPoolSize(), configuration.getPrimaryPoolSize(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("primary"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchSetWeights(Map<String, String> weights, String position) {
        Jedis jedis = null;
        try {
            jedis = this.jedisPool.getResource();
            jedis.hmset(TicketKeyGenerator.Weight.getWeight((String)position).generateKey(), weights);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Scheduled(initialDelay=5000L, fixedDelay=600000L)
    public void schedule() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting calculation weight ...");
        }
        List tickets = this.ticketService.getAllTickets();
        Map positions = this.fetcher.hfetchall(TicketKeyGenerator.Media.getPositions(), null, Position.class);
        if (MapUtils.isEmpty((Map)positions)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Fetching position is empty!");
            }
            return;
        }
        if (CollectionUtils.isEmpty((Collection)tickets)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No any ticket!");
            }
            return;
        }
        try {
            long start = System.currentTimeMillis();
            final ArrayList cpc = Lists.newArrayList();
            final ArrayList cpa = Lists.newArrayList();
            for (Ticket ticket : tickets) {
                final BigInteger ticketId = ticket.getId();
                BigDecimal globalArpu = (BigDecimal)this.jedisFetcherForOld.fetch(new KeyGenerator(){

                    public String generateKey() {
                        return KeyBuilder.build((Object[])new Object[]{"AD", "ARPU", "TICKET", ticketId});
                    }
                }, null, BigDecimal.class);
                if (ticket.getSettleType() == 1) {
                    cpc.add(TicketWeight.of(ticket, null == globalArpu ? new BigDecimal(0.1) : globalArpu, ticket.isOcpc()));
                    continue;
                }
                if (ticket.getSettleType() != 2) continue;
                cpa.add(TicketWeight.of(ticket, null == globalArpu ? new BigDecimal(0.02) : globalArpu, ticket.isOcpc()));
            }
            final ConcurrentMap mifCache = Maps.newConcurrentMap();
            final ConcurrentMap pfCache = Maps.newConcurrentMap();
            final AtomicInteger count = new AtomicInteger(1);
            ArrayList futures = Lists.newArrayList();
            Set entries = positions.entrySet();
            int size = entries.size();
            for (final Map.Entry positionEntry : entries) {
                Future<Integer> future = this.primaryPool.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        Position value = (Position)positionEntry.getValue();
                        String position = value.getId();
                        Map<String, BigDecimal> cpcArups = WeightCalculateScheduler.this.cpcArupCalculator.getArups(cpc, position);
                        Map<String, BigDecimal> cpaArups = WeightCalculateScheduler.this.cpaArupCalculator.getArups(cpa, position);
                        this.setWeight(cpcArups, position, 1);
                        this.setWeight(cpaArups, position, 2);
                        return count.getAndIncrement();
                    }

                    private void setWeight(Map<String, BigDecimal> map, String position, int settlement) {
                        if (MapUtils.isEmpty(map)) {
                            return;
                        }
                        long start = System.currentTimeMillis();
                        HashMap weights = Maps.newHashMap();
                        Set<Map.Entry<String, BigDecimal>> entries = map.entrySet();
                        for (Map.Entry<String, BigDecimal> entry : entries) {
                            BigDecimal priceFloat;
                            BigInteger ticketId = TypeHelper.castToBigInteger((Object)entry.getKey());
                            BigDecimal intervene = (BigDecimal)mifCache.get(ticketId);
                            if (null == intervene) {
                                intervene = WeightCalculateScheduler.this.mifCalculator.getMif(ticketId);
                                mifCache.put(ticketId, intervene);
                            }
                            if (null == (priceFloat = (BigDecimal)pfCache.get(ticketId))) {
                                priceFloat = WeightCalculateScheduler.this.priceFloatCalculator.getPf(ticketId);
                                pfCache.put(ticketId, priceFloat);
                            }
                            BigDecimal arup = entry.getValue();
                            BigDecimal weight = arup.multiply(priceFloat).multiply(intervene).setScale(7, RoundingMode.HALF_UP);
                            String field = String.valueOf(ticketId);
                            weights.put(field, TypeHelper.castToString((Object)weight));
                        }
                        WeightCalculateScheduler.this.batchSetWeights(weights, position);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Processing finished map size {} in {} ms", (Object)map.size(), (Object)(System.currentTimeMillis() - start));
                        }
                    }
                });
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    Integer index = (Integer)future.get();
                    boolean isPrint = index % 100 == 0 || index == size;
                    if (!isPrint || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Processing {}/{}", (Object)index, (Object)size);
                }
                catch (InterruptedException | ExecutionException e) {
                    if (!LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("get: ", (Throwable)e);
                }
            }
            mifCache.clear();
            pfCache.clear();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("All ticket weight has been finished getPf in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        finally {
            this.cpcArupCalculator.flushTempCache();
            this.cpaArupCalculator.flushTempCache();
        }
    }

    private String createPathname() {
        LocalDateTime time = LocalDateTime.now();
        String fileName = time.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        return StringUtils.removeEnd((String)System.getProperty("java.io.tmpdir"), (String)File.separator) + File.separator + fileName;
    }

    private void write(String pathname, List<String> lines) {
        block3: {
            File file = new File(pathname);
            try {
                if (file.exists() || file.createNewFile()) {
                    FileUtils.writeLines((File)file, lines, (boolean)true);
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block3;
                LOGGER.error("createNewFile:", (Throwable)e);
            }
        }
    }

    static class RunningResult {
        long index;
        String info;

        public RunningResult(long index, String info) {
            this.index = index;
            this.info = info;
        }
    }
}

