package com.bxm.adx.facade.constant.enums;

import java.util.Objects;

/**
 * 设备系统类型<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/27 17:47
 */
public enum DevOsEnum {

    /** 未知 */
    UNKOWN(0, "0", "未知"),
    /** 安卓 */
    ANDROID(1, "1", "安卓"),
    /** IOS */
    IOS(2, "2", "IOS"),
    ;
    
    /**
     * 系统类型
     */
    private int id;
    /**
     * 系统类型
     */
    private String code;
    /**
     * 描述
     */
    private String desc;
    
    private DevOsEnum(int id, String code, String desc){
        this.id = id;
        this.code = code;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据原值返回枚举
     * @param id 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain DevOsEnum.UNKOWN}
     */
    public static DevOsEnum of(Integer id) {
        DevOsEnum[] values = values();
        for (DevOsEnum value : values) {
            if (Objects.equals(value.id, id)) {
                return value;
            }
        }
        return UNKOWN;
    }

    /**
     * 根据原值返回枚举
     * @param code 原值
     * @return 如果原值未定义，那么统一返回 {@linkplain DevOsEnum.UNKOWN}
     */
    public static DevOsEnum of(String code) {
        DevOsEnum[] values = values();
        for (DevOsEnum value : values) {
            if (Objects.equals(value.code, code)) {
                return value;
            }
        }
        return UNKOWN;
    }
}
