package com.bxm.adx.facade.constant.enums;

/**
 * <p>
 * SDK支持的特定版本枚举
 * </p>
 *
 * @author zhengwangeng
 * @since 2020/12/23 14:20
 */
public enum SdkVersionEnum {

    /**
     * 支持调度频次控制
     */
    SUPPORT_FREQUENCY_243("2.4.3", "支持调度频次控制"),

    /**
     * 支持变现猫兜底
     */
    SUPPORT_BXM_BACKUP_30("3.0", "支持变现猫兜底"),

    /**
     * 支持deeplink
     */
    SUPPORT_DEEPLINK_310("3.1.0", "支持deeplink"),

    /**
     * 三码合一的异常校验
     */
    SUPPORT_EXCEPTION_325("3.2.5", "支持异常"),

    /**
     * IOS-支持百度和快手
     */
    IOS_SUPPORT_BD_AND_KS_331("3.3.1", "IOS-支持百度和快手"),

    /**
     * IOS支持推送之外的新字段
     */
    IOS_SUPPORT_LOCKSCREEN("3.3.3", "IOS支持推送之外的新字段")
    ;

    private String version;
    private String desc;

    SdkVersionEnum(String version, String desc) {
        this.version = version;
        this.desc = desc;
    }

    public String getVersion() {
        return version;
    }

    public String getDesc() {
        return desc;
    }
}
