package com.bxm.adx.facade.rule.task;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

/**
 * 抽象的三个元素组成的规则
 * <pre>
 *     {one}-{two}-{three}
 * </pre>
 * @author allen
 * @date 2017-12-06
 */
public abstract class AbstractThreeRule extends RuleSo {

    /**
     * 添加分组值
     * @param one
     * @param two
     * @param three
     */
    protected abstract void addItem(int one, int two, long three);

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if(StringUtils.isBlank(value)){
            return;
        }

        String[] items = StringUtils.split(value, ',');
        for (String item : items) {
            String[] entry = StringUtils.split(item, '-');
            if (null == entry || entry.length != 3) {
                continue;
            }
            int one = NumberUtils.toInt(entry[0], -1);
            int two = NumberUtils.toInt(entry[1], -1);
            long three = NumberUtils.toLong(entry[2], -1);
            addItem(one, two, three);
        }
    }
}
