package com.bxm.adx.facade.rule.task;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 任务信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/25 19:31
 */
@Data
public class TaskCache implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    private Long id;
    /**
     * 有效期开始
     */
    private Date startDate;
    /**
     * 有效期结束
     */
    private Date endDate;
    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务
     */
    private Integer type;
    /**
     * 总曝光限制。0表示不限
     */
    private Long viewTotalLimit;
    /**
     * 日曝光限制。0表示不限
     */
    private Long viewDayLimit;
    /**
     * 总点击限制。0表示不限
     */
    private Long clickTotalLimit;
    /**
     * 日点击限制。0表示不限
     */
    private Long clickDayLimit;
    /**
     * 总唤醒限制。0表示不限
     */
    private Long wakeUpTotalLimit;
    /**
     * 日唤醒限制。0表示不限
     */
    private Long wakeUpDayLimit;
    /**
     * 曝光点击间隔不超过该值，单位为秒
     */
    private Integer viewClickInterval;
    /**
     * 唤醒回到桌面不超过该值，单位为秒
     */
    private Integer wakeUpToDesktop;
    /**
     * 应用包名
     */
    private String packageName;
    /**
     * 跳转协议
     */
    private String jumpProtocol;
    /**
     * 唤醒检查接口。0:无 、1:腾讯新闻
     */
    private Integer wakeCheckApi;
    /**
     * 下发监测地址，多个用逗号分隔
     */
    private String acquireMonitorUrl;
    /**
     * 曝光监测地址，多个用逗号分隔
     */
    private String viewMonitorUrl;
    /**
     * 点击监测地址，多个用逗号分隔
     */
    private String clickMonitorUrl;
    /**
     * 准备就绪监测地址，多个用逗号分隔
     */
    private String readyMonitorUrl;
    /**
     * 唤醒完成监测地址，多个用逗号分隔
     */
    private String wakeUpMonitorUrl;
    /**
     * 唤醒成功监测地址，多个用逗号分隔
     */
    private String wakeSucceedMonitorUrl;
    /**
     * 操作系统。1-安卓，2-IOS
     */
    private Integer os;
    /**
     * 优先级
     */
    private Integer priority;
    /**
     * 口令内容
     */
    private String cmdText;
    /**
     * 口令接口,0- 无
     */
    private Integer cmdApi;
    /**
     * 时间间隔,同一设备同一任务的下发时间间隔，单位为分钟
     */
    private Integer timeInterval;
    
}
