package com.bxm.adx.facade.exception;

import com.bxm.adx.facade.constant.enums.AdxErrEnum;

/**
 * @author allen
 * @since 2019-12-16
 */
public class AdxException extends RuntimeException {

    private static final long serialVersionUID = -3800311693149779045L;
    private Integer code;
    private AdxErrEnum adxErrEnum;

    public AdxException() {
    }

    public AdxException(String message) {
        super(message);
        this.code = 200;
    }

    public AdxException(AdxErrEnum adxErrEnum) {
        super(adxErrEnum.getMsg());
        this.code = 200;
        this.adxErrEnum = adxErrEnum;
    }

    public AdxException(String message, Throwable cause) {
        super(message, cause);
    }

    public AdxException(Throwable cause) {
        super(cause);
    }

    public AdxException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public AdxException(String message, Integer code) {
        super(message);
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public AdxErrEnum getAdxErrEnum() {
        return adxErrEnum;
    }
}
