package com.bxm.adx.facade.rule.task;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * 任务地域规则<br/>
 * <pre>
 *     {regionCode},{regionCode},{regionCode}...
 *
 *     {regionCode} => 地域代码
 * </pre>
 *
 * @author kerry.jiang
 * @date 2020/3/26 18:19
 */
public class TaskRegionRuleSo extends RuleSo {

    @JSONField(deserialize = false, serialize = false)
    private List<String> entries = Lists.newArrayList();

    public List<String> getEntries() {
        return entries;
    }

    @Override
    public void setRuleValue(String ruleValue) {
        super.setRuleValue(ruleValue);

        String value = super.getRuleValue();

        if (StringUtils.isBlank(value)) {
            return;
        }

        String[] items = StringUtils.split(value, ',');
        for (String item : items) {
            this.entries.add(item);
        }
    }
}
