package com.bxm.adx.facade.service;

import com.bxm.adx.facade.constant.Constants;
import com.bxm.adx.facade.model.dev.DevRequest;
import com.bxm.adx.facade.model.dev.SdkInitCache;
import com.bxm.adx.facade.model.dev.UserProfile;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/9/21 11:32
 */
@Deprecated
@FeignClient(Constants.SERVER_NAME)
public interface UserService {

    /**
     * 获取用户信息<br/>
     *
     * @param request
     * @return com.bxm.adx.facade.model.dev.UserProfile
     */
    @RequestMapping(path = "/userService/getUser", method = RequestMethod.POST)
    UserProfile getUser(@RequestBody DevRequest request);

    /**
     * 获取SDK初始化信息（推荐）<br/>
     *
     * @param request 设备号相关信息
     * @return com.bxm.adx.facade.model.dev.SdkInitCache
     */
    @RequestMapping(path = "/userService/getSdkInit", method = RequestMethod.POST)
    SdkInitCache getSdkInit(@RequestBody DevRequest request);

    /**
     * 获取SDK初始化信息<br/>
     *
     * @param uid @see com.bxm.adx.facade.service.UserService.getUser()
     * @return com.bxm.adx.facade.model.dev.SdkInitCache
     */
    @RequestMapping(path = "/userService/getSdkInitByUid", method = RequestMethod.GET)
    SdkInitCache getSdkInitByUid(@RequestParam(value = "uid", required = true) String uid);

    /**
     * 获取SDK初始化时的已安装APP包名列表（推荐）<br/>
     * 仅支持安卓<br/>
     *
     * @param request 设备号相关信息
     * @return java.util.List<java.lang.String>
     */
    @RequestMapping(path = "/userService/getInstalledList", method = RequestMethod.POST)
    List<String> getInstalledList(@RequestBody DevRequest request);

    /**
     * 获取SDK初始化时的已安装APP包名列表<br/>
     * 仅支持安卓<br/>
     *
     * @param uid @see com.bxm.adx.facade.service.UserService.getUser()
     * @return java.util.List<java.lang.String>
     */
    @RequestMapping(path = "/userService/getInstalledListByUid", method = RequestMethod.GET)
    List<String> getInstalledListByUid(@RequestParam(value = "uid", required = true) String uid);
}
