package com.bxm.adx.facade.model.task;

import com.bxm.warcar.ip.IP;
import lombok.Data;

/**
 * 任务信息<br/>
 *
 * @author kerry.jiang
 * @date 2020/3/26 11:35
 */
@Data
public class TaskInfoRequest implements java.io.Serializable {

    private static final long serialVersionUID = 9132608548480991005L;
    /**
     * appid(Code)
     */
    private String appId;
    /**
     * 广告位ID
     */
    private String positionId;
    /**
     * 系统类型，1：安卓，2：IOS
     */
    private Integer os;
    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务、3- 复制任务
     */
    private Integer taskType;

    /**
     * IMEI，所属安卓
     */
    private String imei;
    /**
     * IMEI，所属安卓
     */
    private String imei_md5;
    /**
     * 安卓ID
     */
    private String anid;
    /**
     * 安卓ID
     */
    private String anid_md5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * IDFA，所属IOS
     */
    private String idfa;
    /**
     * IDFA，所属IOS
     */
    private String idfa_md5;
    /**
     * 监测类型。1- 监测点击曝光任务、2- 监测全部任务
     */
    private Integer trackerType;
    /**
     * 系统版本
     */
    private String osv;
    /**
     * 操作场景, 1：初始化，2：静默唤醒，3：APP切出
     */
    private Integer opscene;

    
    
    //自动填写
    /**
     * IP地址
     */
    private String ip;
    private IP iprst;
    /**
     * UA信息
     */
    private String ua;
    /**
     * 通过规则从imei/imeiMd5/androidId/androidIdMd5/oaid/idfa/idfaMd5中，获得该值
     */
    private String devUid;
    /**
     * 是否IOS版本大于14
     */
    private Boolean osv_14;
}
