package com.bxm.adx.common.adapter.builder;

import com.bxm.adx.common.AdxConstants;
import com.bxm.adx.common.sell.position.Position;
import com.bxm.adx.common.sell.position.PositionService;
import com.bxm.adx.common.sell.request.Impression;
import com.bxm.adx.common.sell.ssp.SspRequest;
import com.bxm.adx.common.sell.ssp.req.Ad;
import com.bxm.adx.common.sell.ssp.req.App;
import com.bxm.adx.common.sell.ssp.req.Device;
import com.bxm.adx.common.sell.ssp.req.Screen;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Arei on 2020/4/10.
 */
@Slf4j
@Component
public class ConcreteAdxRequestBuilder extends AdxRequestBuilder {
    private PositionService positionService;

    public ConcreteAdxRequestBuilder(PositionService positionService) {
        this.positionService = positionService;
    }

    @Override
    public void buildId(SspRequest sspRequest) {
        request.setId(RandomStringUtils.randomAlphanumeric(8));
    }

    @Override
    public void buildAdxType(SspRequest sspRequest) {

    }

    @Override
    public void buildImps(SspRequest sspRequest) {
        List<Ad> ads = sspRequest.getAds();
        if (log.isDebugEnabled()) {
            log.debug("adssize={}", ads.size());
        }
        List<Impression> impressions = new ArrayList<>(ads.size());
        for (Ad ad : ads) {
            Impression i = new Impression();
            i.setId(RandomStringUtils.randomAlphanumeric(8));
            i.setTag_id(ad.getPlace_token());
            i.setW(ad.getW());
            i.setH(ad.getH());
            Position position = positionService.getByPositionId(ad.getPlace_token());
            if (null == position) {
                throw new IllegalArgumentException();
            }
            i.setType(AdxConstants.Type.getTypeByPositionScene(position.getPositionScene()));

            impressions.add(i);
        }
        if (log.isDebugEnabled()) {
            log.debug("impressionssize={}", impressions.size());
        }

        request.setImps(impressions);
    }

    @Override
    public void buildcType(SspRequest sspRequest) {

    }

    @Override
    public void buildApp(SspRequest sspRequest) {
        App app = sspRequest.getApp();
        com.bxm.adx.common.sell.request.App a = new com.bxm.adx.common.sell.request.App();
        a.setId(RandomStringUtils.randomAlphanumeric(6));
        a.setName(app.getName());
        a.setBundle(app.getBundle());
        request.setApp(a);
    }

    @Override
    public void buildDevice(SspRequest sspRequest) {
        Device device = sspRequest.getDevice();
        com.bxm.adx.common.sell.request.Device d = new com.bxm.adx.common.sell.request.Device();
        d.setUa(device.getUa());
        d.setIp(device.getIp());
        d.setImei(device.getImei());
        d.setImei_md5(device.getImei_md5());
        d.setIdfa(device.getIdfa());
        d.setIdfa_md5(device.getIdfa_md5());
        d.setDpid(device.getAndroid_id());
        d.setMake(device.getMake());
        d.setModel(device.getModel());
        d.setOs(device.getOs());
        d.setOsv(device.getOs_version());
        d.setBrand(device.getBrand());
        Screen screen = device.getScreen();
        if (null != screen) {
            d.setW(screen.getW());
            d.setH(screen.getH());
        }

        // FIXME: 2020/2/19 我们自己协议里不强制要求，但是下游有些dsp强制要求（比如金橙），这里需要调整，把写死的部分下放到dsp的适配器中
        d.setConnection_type(1);
        d.setImsi("46003");
        request.setDevice(d);
    }

    @Override
    public void buildUser(SspRequest sspRequest) {

    }

    @Override
    public void buildGeo(SspRequest sspRequest) {

    }

    @Override
    public void buildCur(SspRequest sspRequest) {

    }

    @Override
    public void buildBidType(SspRequest sspRequest) {
        request.setBid_type(1);
    }

    @Override
    public void buildAt(SspRequest sspRequest) {
        request.setAt(1);
    }

    @Override
    public void buildDealIds(SspRequest sspRequest) {

    }

    @Override
    public void buildBillType(SspRequest sspRequest) {

    }

    @Override
    public void buildTest(SspRequest sspRequest) {
        Integer test = sspRequest.getTest();
        request.setTest(null == test ? 0 : test);
    }

    @Override
    public void buildtMax(SspRequest sspRequest) {
        request.setT_max(100);
    }

    @Override
    public void buildbCat(SspRequest sspRequest) {

    }

    @Override
    public void buildbSeat(SspRequest sspRequest) {

    }

    @Override
    public void buildwSeat(SspRequest sspRequest) {

    }

    @Override
    public void buildbAdv(SspRequest sspRequest) {

    }

    @Override
    public void buildbApp(SspRequest sspRequest) {

    }

    @Override
    public void buildExt(SspRequest sspRequest) {

    }

    @Override
    public void buildAdType(SspRequest sspRequest) {

    }
}
