package com.bxm.adx.common;

/**
 * @author allen
 * @since 2019-12-16
 */
public class AdxConstants {


    public static final byte YES = 1;
    public static final byte NO = 0;

    public static final int  ADX_REQ= 15001;
    public static final int  ADX_RESP= 15104;
    public static final int  DSP_REQ= 15002;
    public static final int  DSP_RESP= 15103;
    /**
     * 广告创意类型
     */
    public enum Type {
        NATIVE(1),
        IMAGE(2),
        VIDEO(3),
        TEXT(4),
        INSPIRE_VIDEO(5);
        private Integer type;

        Type(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return type;
        }

        public static Integer getTypeByPositionScene(Byte scene) {
            PositionSceneTypeEnum sceneTypeEnum = PositionSceneTypeEnum.get(scene.intValue());
            switch (sceneTypeEnum) {
                case INFORMATION_FLOW:
                    return NATIVE.getType();
                case BOOT:
                    return IMAGE.getType();
                case SCREEN:
                    return IMAGE.getType();
                case BUTTON:
                    return IMAGE.getType();
                case INFORMATION_FLOW_SELF_RENDERING:
                    return NATIVE.getType();
                case BANNER:
                    return IMAGE.getType();
                case ICON:
                    return IMAGE.getType();
                case VIDEO:
                    return VIDEO.getType();
                case INSPIRE_VIDEO:
                    return INSPIRE_VIDEO.getType();

            }
            return null;
        }
    }

    public enum Action {
        UNKNOW(0),
        DOWNLOAD_ANDROID(2),
        DOWNLOAD_IOS(3),
        WEB_VIEW(6),
        DEEP_LINK(9);
        private int action;

        Action(int action) {
            this.action = action;
        }

        public int getAction() {
            return action;
        }
    }


}
