package com.bxm.adx.common.adapter;

import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;

/**
 * 买方模型适配器
 *
 * @author allen
 * @since 2019-12-12
 */
public interface BuyModelAdapter extends ModelAdapter {

    /**
     * 将卖方请求转换成买方请求
     * @param request 卖方请求
     * @return 买方请求
     */
    byte[] buildRequest(BidRequest request);

    /**
     * 将卖方响应转换成买方响应
     * @param response 卖方响应
     * @return 买方响应
     */
    BidResponse buildResponse(byte[] response);
}
