package com.bxm.adx.common.buy.buyers;

import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.buy.dispatcher.DispatcherService;
import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.plugin.PluginHolder;
import com.bxm.adx.common.sell.position.Position;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @since 2019-12-16
 */
@Primary
@Configuration
public class DispatcherPluginBuyersImpl extends AbstractPluginBuyersImpl {

    private DispatcherService dispatcherService;

    protected DispatcherPluginBuyersImpl(PluginHolder pluginHolder) {
        super(pluginHolder);
    }

    @Override
    public List<List<Buyer>> findAsPriority(Position position) {
        String positionId = position.getPositionId();
        Map<Integer, Collection<Dsp>> dsps = dispatcherService.getPriority(positionId);

        List<List<Buyer>> list = Lists.newArrayList();
        Map<String, Buyer> buyers = getAllBuyers();
        for (Map.Entry<Integer, Collection<Dsp>> entry : dsps.entrySet()) {
            Integer priority = entry.getKey();
            Collection<Dsp> value = entry.getValue();
            int index = priority - 1;
            List<Buyer> buyerList = CollectionUtils.isEmpty(list) ? null : list.size() > index ? list.get(index) : null;
            if (null == buyerList) {
                buyerList = Lists.newArrayList();
                list.add(index, buyerList);
            }
            for (Dsp dsp : value) {
                String dspCode = dsp.getDspCode();
                Buyer buyer = buyers.get(dspCode);
                if (null != buyer) {
                    buyerList.add(buyer);
                }
            }
        }
        return list;
    }

    @Autowired
    public void setDispatcherService(DispatcherService dispatcherService) {
        this.dispatcherService = dispatcherService;
    }
}
