package com.bxm.adx.common.buy.dispatcher;

import com.bxm.adx.common.buy.dsp.Dsp;
import com.bxm.adx.common.buy.dsp.DspService;
import com.bxm.adx.common.utils.MapHelper;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/**
 * @author allen
 * @since 2019-12-16
 */
@Configuration
public class DispatcherServiceImpl implements DispatcherService {

    private final DispatcherDao dispatcherDao;
    private final DspService dspService;

    public DispatcherServiceImpl(DispatcherDao dispatcherDao, DspService dspService) {
        this.dispatcherDao = dispatcherDao;
        this.dspService = dspService;
    }

    @Override
    public Map<Integer, Collection<Dsp>> getPriority(String positionId) {
        Collection<Dispatcher> dispatchers = dispatcherDao.get(positionId);
        Map<Integer, Collection<Dsp>> dsps = Maps.newHashMap();
        if (CollectionUtils.isEmpty(dispatchers)) {
            return dsps;
        }
        for (Dispatcher dispatcher : dispatchers) {
            if (!dispatcher.isOpened()) {
                continue;
            }
            int priority = dispatcher.getPriority();
            Long dspId = dispatcher.getDspId();
            Dsp dsp = dspService.get(dspId);
            Collection<Dsp> collection = MapHelper.get(dsps, priority, new ArrayList<>());
            collection.add(dsp);
        }
        return dsps;
    }
}
