package com.bxm.adx.common.market;

import com.bxm.adx.common.adapter.BuyModelAdapter;
import com.bxm.adx.common.buy.Buyer;
import com.bxm.adx.common.sell.BidRequest;
import com.bxm.adx.common.sell.BidResponse;
import com.bxm.adx.common.sell.response.Bid;
import com.bxm.adx.common.sell.response.SeatBid;
import org.apache.commons.lang.RandomStringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 成交信息，包含买家、卖家等信息
 *
 * @author allen
 * @since 2019-12-13
 */
public class Deal {

    private Buyer buyer;

    private byte[] request;
    private byte[] response;

    private BidResponse bidResponse;
    private BidRequest bidRequest;

    public Deal(Buyer buyer, byte[] request, byte[] response, BidRequest bidRequest) {
        this.buyer = buyer;
        this.request = request;
        this.response = response;
        this.bidRequest = bidRequest;
    }

    public BidResponse getBidResponse() {
        if (null == bidResponse) {
            BuyModelAdapter modelAdapter = buyer.getModelAdapter();
            if (null != response && response.length > 0) {
                this.bidResponse = modelAdapter.buildResponse(response);
                if (null != this.bidResponse) {
                    if (StringUtils.isEmpty(bidResponse.getId())) {
                        bidResponse.setId(bidRequest.getId());
                    }
                    // FIXME: 2020/2/24 以下循环的逻辑因为dsp不支持返回tagid和cid
                    if (!CollectionUtils.isEmpty(bidResponse.getSeat_bid())) {
                        List<Bid> bidList = bidResponse.getSeat_bid().stream()
                                .map(SeatBid::getBid).flatMap(Collection::stream).collect(Collectors.toList());
                        for (Bid bid : bidList) {
                            if (StringUtils.isEmpty(bid.getTag_id())) {
                                bid.setTag_id(bidRequest.getImps().get(0).getTag_id());
                            }
                            if (StringUtils.isEmpty(bid.getCreate_id())) {
                                bid.setCreate_id(RandomStringUtils.random(6));
                            }
                        }
                    }
                }

            }
        }
        return bidResponse;
    }

    public Buyer getBuyer() {
        return buyer;
    }

    public void setBuyer(Buyer buyer) {
        this.buyer = buyer;
    }

    public byte[] getRequest() {
        return request;
    }

    public void setRequest(byte[] request) {
        this.request = request;
    }

    public byte[] getResponse() {
        return response;
    }

    public void setResponse(byte[] response) {
        this.response = response;
    }

    public BidRequest getBidRequest() {
        return bidRequest;
    }
}
