package com.bxm.adx.common.sdkconfig;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import com.bxm.adx.facade.constant.pushable.CachePushableFields;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.cache.Updater;
import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.KeyBuilder;

/**
 *
 * For cache pushable
 *
 * <pre>
 * name = "POSITION_SDK_CONFIG"
 * parameters = {positionId=$positionId}
 * byte[] = PositionSdkConfig object to json bytes
 * </pre>
 * @author zhengwangeng
 * @since 2020-1-7
 */
@Component
@CachePush("POSITION_SDK_CONFIG")
public class SdkConfigDaoImpl implements SdkConfigDao, Pushable {

    private final Fetcher fetcher;
    private final Updater updater;

    public SdkConfigDaoImpl(Fetcher fetcher, Updater updater) {
        this.fetcher = fetcher;
        this.updater = updater;
    }

    @Override
    public List<SdkConfig> getByPositionId(String positionId) {
        return fetcher.fetchList(getKeyGenerator(positionId), SdkConfig.class);
    }

    @Override
    public void push(Map<String, Object> parameters, byte[] data) {
        Object o = parameters.get(CachePushableFields.POSITION_ID);
        if (Objects.isNull(o)) {
            return;
        }
        String positionId = Objects.toString(o);
        List<SdkConfig> sdkConfigList = JsonHelper.convert(data, List.class);

        updater.remove(getKeyGenerator(positionId));
        if(CollectionUtils.isNotEmpty(sdkConfigList)){
            updater.update(getKeyGenerator(positionId), sdkConfigList);
        }
    }

    private KeyGenerator getKeyGenerator(String value) {
        return () -> KeyBuilder.build("ADX", "POSITION_SDK_CONFIG", "POSITION_ID", value);
    }
}
