package com.bxm.adx.common.sell.position.dsp;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Lists;

import lombok.Data;

/**
 * 广告位场景-媒体入口素材。</br>
 * Created by zhengwangeng on 2020/5/28 11:29.
 */
@Data
public class MediaEntranceCreative implements Serializable {

    private static final long serialVersionUID = 1733401522239243683L;

    /**
     * 原生图文
     */
    public static final short POSITION_TYPE_NATIVE = 1;
    /**
     * 图片
     */
    public static final short POSITION_TYPE_PICTURE = 2;
    /**
     * 文字
     */
    public static final short POSITION_TYPE_TEXT = 3;
    /**
     * 视频
     */
    public static final short POSITION_TYPE_VIDEO = 4;


    private BigInteger creativeId;
    private String positionId;
    private short positionType;
    private String positionTypeDesc;
    private String creativeName;
    private String creativeIcon;
    private String creativeTitle;
    private String creativeContent;
    private String creativePicture;
    private String creativeCover;
    private String creativeVideo;
    /**
     * 开关,1:开,0:关
     */
    private Integer opened;

    public List<String> getCreativeContentList() {
        if(StringUtils.isBlank(this.getCreativeContent())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeContent(), ","));
    }

    public List<String> getCreativePictures() {
        if(StringUtils.isBlank(this.getCreativePicture())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativePicture(), ","));
    }

    public List<String> getCreativeCoverList() {
        if(StringUtils.isBlank(this.getCreativeCover())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeCover(), ","));
    }

    public List<String> getCreativeVideoList() {
        if(StringUtils.isBlank(this.getCreativeVideo())){
            return null;
        }
        return Lists.newArrayList(StringUtils.splitPreserveAllTokens(this.getCreativeVideo(), ","));
    }

    public boolean isOpen() {
        if (null == opened) {
            //由于字段是后来加的，并且素材list开始只支持配置一个，为了避免未初始化，默认null为素材开启状态
            return true;
        } else {
            if (1 == opened) {
                return true;
            } else {
                return false;
            }
        }
    }
}

