package com.bxm.adx.common.utils;

import java.util.Map;

/**
 * @author allen
 * @since 2019-12-20
 */
public final class MapHelper {

    /**
     * 获取 Map 集合指定 {@code k} 的 {@code value}，如果为空，那么将 {@code initialize} 作为初始化值插入到集合中。
     * @param map 集合
     * @param k Key
     * @param initialize 初始化值
     * @param <K> K 泛型
     * @param <V> V 泛型
     * @return 如果 {@code k} 的值为空，那么返回 {@code initialize} 值。否则返回已存在的 {@code value} 对象。
     */
    public static <K, V> V get(Map<K, V> map, K k, V initialize) {
        V value = map.get(k);
        if (null == value) {
            map.put(k, initialize);
            return initialize;
        }
        return value;
    }
}
