package com.bxm.adx.common.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.util.CollectionUtils;

import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;

/**
 * @author allen
 * @date 2019/6/26
 * @since 1.0.0
 */
@Slf4j
public final class ServletUtils {

    public static byte[] getBodyForBuffer(HttpServletRequest request) {
        ServletInputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;

        try {
            inputStream = request.getInputStream();
            outputStream = new ByteArrayOutputStream();
            int len = -1;

            // 设置缓冲区大小
            byte[] buff = new byte[2048];

            while ((len = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, len);
            }
            outputStream.flush();
            return outputStream.toByteArray();
        } catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("read request input stream occur error!", e);
            }
            return new byte[0];
        } finally {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header) {
        println(response, data, header, true);
    }

    public static void println(HttpServletResponse response, byte[] data, Map<String, String> header, boolean closeStream) {
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            if (data != null) {
                out.write(data);
            }
            if (!CollectionUtils.isEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    response.setHeader(entry.getKey(), entry.getValue());
                }
            }
            out.flush();
        } catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("writer resp body err", e);
            }
        } finally {
            if (closeStream) {
                // 尽量不要让容器来关闭
                IOUtils.closeQuietly(out);
            }
        }
    }
}
