package com.bxm.adx.common.utils;

import com.google.common.base.Preconditions;
import org.springframework.util.StringUtils;

/**
 * 埋点url处理
 *
 * @Author: Areit
 * @Date: 2019-08-12 16:33
 */
public class UrlUtils {
    private static final String BID_MACRO = "__BID_COMMON_REQUEST_ID__";
    private static final String TAG_MACRO = "__TAGID__";
    private static final String CREATE_MACRO = "__CREATEID__";
    private static final String TIME_MACRO = "__TIME__";
    private static final String MT_MACRO = "__MT__";
    private static final String DSPID_MACRO = "__DSPID__";
    private static final String IP_MACRO = "__IP__";
    private static final String ACTIVITY_ID_MACRO = "__ACTIVITY_ID__";
    private static final String SCENE_TYPE_MACRO = "__SCENE_TYPE__";
    public static String convertParam(String url ,String bidId, String time, String tagId, String createId, String mt,
                                      String dspId, String ip, String actId, String scene) {
        Preconditions.checkNotNull(url,"url is null");
        Preconditions.checkNotNull(bidId,"bidId is null");
        Preconditions.checkNotNull(tagId,"tagId is null");
        Preconditions.checkNotNull(createId,"createId is null");
        Preconditions.checkNotNull(time,"time is null");
        Preconditions.checkNotNull(mt,"mt is null");
        Preconditions.checkNotNull(dspId,"dspId is null");
        if (url.contains(BID_MACRO)) {
            url = url.replace(BID_MACRO, bidId);
        }
        if (url.contains(TAG_MACRO)) {
            url = url.replace(TAG_MACRO, tagId);
        }
        if (url.contains(CREATE_MACRO)) {
            url = url.replace(CREATE_MACRO, createId);
        }
        if (url.contains(TIME_MACRO)) {
            url = url.replace(TIME_MACRO, time);
        }
        if (url.contains(MT_MACRO)) {
            url = url.replace(MT_MACRO, mt);
        }
        if (url.contains(DSPID_MACRO)) {
            url = url.replace(DSPID_MACRO, dspId);
        }
        if (url.contains(IP_MACRO)) {
            url = url.replace(IP_MACRO, ip);
        }
        if (url.contains(ACTIVITY_ID_MACRO) && !StringUtils.isEmpty(actId)) {
            url = url.replace(ACTIVITY_ID_MACRO, actId);
        }
        if (url.contains(SCENE_TYPE_MACRO) && !StringUtils.isEmpty(scene)) {
            url = url.replace(SCENE_TYPE_MACRO, scene);
        }

        return url;
    }
}
